<?php

/**
 * TransactionalSMSApi
 * PHP version 5
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 * SendinBlue API
 *
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.29
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
namespace WPMailSMTP\Vendor\SendinBlue\Client\Api;

use WPMailSMTP\Vendor\GuzzleHttp\Client;
use WPMailSMTP\Vendor\GuzzleHttp\ClientInterface;
use WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException;
use WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream;
use WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request;
use WPMailSMTP\Vendor\GuzzleHttp\RequestOptions;
use WPMailSMTP\Vendor\SendinBlue\Client\ApiException;
use WPMailSMTP\Vendor\SendinBlue\Client\Configuration;
use WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector;
use WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer;
/**
 * TransactionalSMSApi Class Doc Comment
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TransactionalSMSApi
{
    /**
     * @var ClientInterface
     */
    protected $client;
    /**
     * @var Configuration
     */
    protected $config;
    /**
     * @var HeaderSelector
     */
    protected $headerSelector;
    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(\WPMailSMTP\Vendor\GuzzleHttp\ClientInterface $client = null, \WPMailSMTP\Vendor\SendinBlue\Client\Configuration $config = null, \WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector $selector = null)
    {
        $this->client = $client ?: new \WPMailSMTP\Vendor\GuzzleHttp\Client();
        $this->config = $config ?: new \WPMailSMTP\Vendor\SendinBlue\Client\Configuration();
        $this->headerSelector = $selector ?: new \WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector();
    }
    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }
    /**
     * Operation getSmsEvents
     *
     * Get all your SMS activity (unaggregated events)
     *
     * @param  int $limit Number of documents per page (optional, default to 50)
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $offset Index of the first document of the page (optional, default to 0)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $phoneNumber Filter the report for a specific phone number (optional)
     * @param  string $event Filter the report for specific events (optional)
     * @param  string $tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\GetSmsEventReport
     */
    public function getSmsEvents($limit = '50', $startDate = null, $endDate = null, $offset = '0', $days = null, $phoneNumber = null, $event = null, $tags = null, $sort = 'desc')
    {
        list($response) = $this->getSmsEventsWithHttpInfo($limit, $startDate, $endDate, $offset, $days, $phoneNumber, $event, $tags, $sort);
        return $response;
    }
    /**
     * Operation getSmsEventsWithHttpInfo
     *
     * Get all your SMS activity (unaggregated events)
     *
     * @param  int $limit Number of documents per page (optional, default to 50)
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $offset Index of the first document of the page (optional, default to 0)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $phoneNumber Filter the report for a specific phone number (optional)
     * @param  string $event Filter the report for specific events (optional)
     * @param  string $tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\GetSmsEventReport, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSmsEventsWithHttpInfo($limit = '50', $startDate = null, $endDate = null, $offset = '0', $days = null, $phoneNumber = null, $event = null, $tags = null, $sort = 'desc')
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsEventReport';
        $request = $this->getSmsEventsRequest($limit, $startDate, $endDate, $offset, $days, $phoneNumber, $event, $tags, $sort);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsEventReport', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSmsEventsAsync
     *
     * Get all your SMS activity (unaggregated events)
     *
     * @param  int $limit Number of documents per page (optional, default to 50)
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $offset Index of the first document of the page (optional, default to 0)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $phoneNumber Filter the report for a specific phone number (optional)
     * @param  string $event Filter the report for specific events (optional)
     * @param  string $tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSmsEventsAsync($limit = '50', $startDate = null, $endDate = null, $offset = '0', $days = null, $phoneNumber = null, $event = null, $tags = null, $sort = 'desc')
    {
        return $this->getSmsEventsAsyncWithHttpInfo($limit, $startDate, $endDate, $offset, $days, $phoneNumber, $event, $tags, $sort)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation getSmsEventsAsyncWithHttpInfo
     *
     * Get all your SMS activity (unaggregated events)
     *
     * @param  int $limit Number of documents per page (optional, default to 50)
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $offset Index of the first document of the page (optional, default to 0)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $phoneNumber Filter the report for a specific phone number (optional)
     * @param  string $event Filter the report for specific events (optional)
     * @param  string $tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSmsEventsAsyncWithHttpInfo($limit = '50', $startDate = null, $endDate = null, $offset = '0', $days = null, $phoneNumber = null, $event = null, $tags = null, $sort = 'desc')
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsEventReport';
        $request = $this->getSmsEventsRequest($limit, $startDate, $endDate, $offset, $days, $phoneNumber, $event, $tags, $sort);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'getSmsEvents'
     *
     * @param  int $limit Number of documents per page (optional, default to 50)
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $offset Index of the first document of the page (optional, default to 0)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $phoneNumber Filter the report for a specific phone number (optional)
     * @param  string $event Filter the report for specific events (optional)
     * @param  string $tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getSmsEventsRequest($limit = '50', $startDate = null, $endDate = null, $offset = '0', $days = null, $phoneNumber = null, $event = null, $tags = null, $sort = 'desc')
    {
        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling TransactionalSMSApi.getSmsEvents, must be smaller than or equal to 100.');
        }
        $resourcePath = '/transactionalSMS/statistics/events';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($startDate !== null) {
            $queryParams['startDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($startDate);
        }
        // query params
        if ($endDate !== null) {
            $queryParams['endDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($endDate);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($days !== null) {
            $queryParams['days'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($days);
        }
        // query params
        if ($phoneNumber !== null) {
            $queryParams['phoneNumber'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($phoneNumber);
        }
        // query params
        if ($event !== null) {
            $queryParams['event'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($event);
        }
        // query params
        if ($tags !== null) {
            $queryParams['tags'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($tags);
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($sort);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('GET', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation getTransacAggregatedSmsReport
     *
     * Get your SMS activity aggregated over a period of time
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param  string $tag Filter on a tag (optional)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\GetTransacAggregatedSmsReport
     */
    public function getTransacAggregatedSmsReport($startDate = null, $endDate = null, $days = null, $tag = null)
    {
        list($response) = $this->getTransacAggregatedSmsReportWithHttpInfo($startDate, $endDate, $days, $tag);
        return $response;
    }
    /**
     * Operation getTransacAggregatedSmsReportWithHttpInfo
     *
     * Get your SMS activity aggregated over a period of time
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param  string $tag Filter on a tag (optional)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\GetTransacAggregatedSmsReport, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransacAggregatedSmsReportWithHttpInfo($startDate = null, $endDate = null, $days = null, $tag = null)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetTransacAggregatedSmsReport';
        $request = $this->getTransacAggregatedSmsReportRequest($startDate, $endDate, $days, $tag);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetTransacAggregatedSmsReport', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTransacAggregatedSmsReportAsync
     *
     * Get your SMS activity aggregated over a period of time
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param  string $tag Filter on a tag (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransacAggregatedSmsReportAsync($startDate = null, $endDate = null, $days = null, $tag = null)
    {
        return $this->getTransacAggregatedSmsReportAsyncWithHttpInfo($startDate, $endDate, $days, $tag)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation getTransacAggregatedSmsReportAsyncWithHttpInfo
     *
     * Get your SMS activity aggregated over a period of time
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param  string $tag Filter on a tag (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransacAggregatedSmsReportAsyncWithHttpInfo($startDate = null, $endDate = null, $days = null, $tag = null)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetTransacAggregatedSmsReport';
        $request = $this->getTransacAggregatedSmsReportRequest($startDate, $endDate, $days, $tag);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'getTransacAggregatedSmsReport'
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param  string $tag Filter on a tag (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getTransacAggregatedSmsReportRequest($startDate = null, $endDate = null, $days = null, $tag = null)
    {
        $resourcePath = '/transactionalSMS/statistics/aggregatedReport';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // query params
        if ($startDate !== null) {
            $queryParams['startDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($startDate);
        }
        // query params
        if ($endDate !== null) {
            $queryParams['endDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($endDate);
        }
        // query params
        if ($days !== null) {
            $queryParams['days'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($days);
        }
        // query params
        if ($tag !== null) {
            $queryParams['tag'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($tag);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('GET', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation getTransacSmsReport
     *
     * Get your SMS activity aggregated per day
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $tag Filter on a tag (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\GetTransacSmsReport
     */
    public function getTransacSmsReport($startDate = null, $endDate = null, $days = null, $tag = null, $sort = 'desc')
    {
        list($response) = $this->getTransacSmsReportWithHttpInfo($startDate, $endDate, $days, $tag, $sort);
        return $response;
    }
    /**
     * Operation getTransacSmsReportWithHttpInfo
     *
     * Get your SMS activity aggregated per day
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $tag Filter on a tag (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\GetTransacSmsReport, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransacSmsReportWithHttpInfo($startDate = null, $endDate = null, $days = null, $tag = null, $sort = 'desc')
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetTransacSmsReport';
        $request = $this->getTransacSmsReportRequest($startDate, $endDate, $days, $tag, $sort);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetTransacSmsReport', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTransacSmsReportAsync
     *
     * Get your SMS activity aggregated per day
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $tag Filter on a tag (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransacSmsReportAsync($startDate = null, $endDate = null, $days = null, $tag = null, $sort = 'desc')
    {
        return $this->getTransacSmsReportAsyncWithHttpInfo($startDate, $endDate, $days, $tag, $sort)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation getTransacSmsReportAsyncWithHttpInfo
     *
     * Get your SMS activity aggregated per day
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $tag Filter on a tag (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransacSmsReportAsyncWithHttpInfo($startDate = null, $endDate = null, $days = null, $tag = null, $sort = 'desc')
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetTransacSmsReport';
        $request = $this->getTransacSmsReportRequest($startDate, $endDate, $days, $tag, $sort);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'getTransacSmsReport'
     *
     * @param  string $startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param  string $endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param  int $days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param  string $tag Filter on a tag (optional)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getTransacSmsReportRequest($startDate = null, $endDate = null, $days = null, $tag = null, $sort = 'desc')
    {
        $resourcePath = '/transactionalSMS/statistics/reports';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // query params
        if ($startDate !== null) {
            $queryParams['startDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($startDate);
        }
        // query params
        if ($endDate !== null) {
            $queryParams['endDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($endDate);
        }
        // query params
        if ($days !== null) {
            $queryParams['days'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($days);
        }
        // query params
        if ($tag !== null) {
            $queryParams['tag'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($tag);
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($sort);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('GET', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation sendTransacSms
     *
     * Send SMS message to a mobile number
     *
     * @param  \SendinBlue\Client\Model\SendTransacSms $sendTransacSms Values to send a transactional SMS (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\SendSms
     */
    public function sendTransacSms($sendTransacSms)
    {
        list($response) = $this->sendTransacSmsWithHttpInfo($sendTransacSms);
        return $response;
    }
    /**
     * Operation sendTransacSmsWithHttpInfo
     *
     * Send SMS message to a mobile number
     *
     * @param  \SendinBlue\Client\Model\SendTransacSms $sendTransacSms Values to send a transactional SMS (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\SendSms, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendTransacSmsWithHttpInfo($sendTransacSms)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\SendSms';
        $request = $this->sendTransacSmsRequest($sendTransacSms);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\SendSms', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 402:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation sendTransacSmsAsync
     *
     * Send SMS message to a mobile number
     *
     * @param  \SendinBlue\Client\Model\SendTransacSms $sendTransacSms Values to send a transactional SMS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendTransacSmsAsync($sendTransacSms)
    {
        return $this->sendTransacSmsAsyncWithHttpInfo($sendTransacSms)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation sendTransacSmsAsyncWithHttpInfo
     *
     * Send SMS message to a mobile number
     *
     * @param  \SendinBlue\Client\Model\SendTransacSms $sendTransacSms Values to send a transactional SMS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendTransacSmsAsyncWithHttpInfo($sendTransacSms)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\SendSms';
        $request = $this->sendTransacSmsRequest($sendTransacSms);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'sendTransacSms'
     *
     * @param  \SendinBlue\Client\Model\SendTransacSms $sendTransacSms Values to send a transactional SMS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendTransacSmsRequest($sendTransacSms)
    {
        // verify the required parameter 'sendTransacSms' is set
        if ($sendTransacSms === null || \is_array($sendTransacSms) && \count($sendTransacSms) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $sendTransacSms when calling sendTransacSms');
        }
        $resourcePath = '/transactionalSMS/sms';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // body params
        $_tempBody = null;
        if (isset($sendTransacSms)) {
            $_tempBody = $sendTransacSms;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Query::build($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[\WPMailSMTP\Vendor\GuzzleHttp\RequestOptions::DEBUG] = \fopen($this->config->getDebugFile(), 'a');
            if (!$options[\WPMailSMTP\Vendor\GuzzleHttp\RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }
        return $options;
    }
}
